package org.test.ui.components;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.shared.Registration;


@Tag("custom-date-picker")
@HtmlImport("frontend://src/components/CustomDatePicker.html")
public class CustomDatePicker extends DatePicker{
	private static final long serialVersionUID = 1L;

	public static String formatDay = "dd/MM/yyyy";
	public static String formatDayHour = "dd/MM/yyyy HH:mm";
	
	public static DateTimeFormatter patternDay = DateTimeFormatter.ofPattern(formatDay);
	public static DateTimeFormatter patterDayHour = DateTimeFormatter.ofPattern(formatDayHour);
	

	String dateTime = null;
	boolean time;
	
	//The original valueChange listener for DatePicker won't be fired if only hour/minute change...
	ArrayList<CustomDateTimeListener> listeners;
	
	
	public CustomDatePicker() {
		this(false);
	}
	
	public CustomDatePicker(boolean time) {
		listeners = new ArrayList<>();		
		setWidth("210px");
		
		if(time){			
			this.getElement().callFunction("_setTimeFeature");		
		}
	}
	
	public ArrayList<CustomDateTimeListener> getCustomDateTimeListeners() {
		return listeners;
	}
	
	public void addCustomDateTimeListener(CustomDateTimeListener listener){
		this.listeners.add(listener);
	}
	
	public void setValue(LocalDateTime dateTime){
		setDateTime(dateTime);
	}
	
	private void setDateTime(String dateTime){	
		if(dateTime.length() == formatDayHour.length()){
			this.getElement().callFunction("setDateTime", dateTime);
		}
		
		this.dateTime = dateTime;		
		setValue(LocalDate.parse(dateTime.substring(0, 10), patternDay));
		
		for(CustomDateTimeListener l : listeners){
			l.valueChange(LocalDateTime.parse(dateTime, patterDayHour));
		}
	}
	
	private void setDateTime(LocalDateTime dateTime){
		setDateTime(dateTime.format(patterDayHour));
	}
	
	public String getDateTimeString(){
		return dateTime;
	}
	
	public LocalDateTime getDateTime(){
		return LocalDateTime.parse(dateTime, patterDayHour);
	}

	@ClientCallable
	private void clientSetDateTime(String time){
		this.setDateTime(time);		
	}
	
	public interface CustomDateTimeListener{
		void valueChange(LocalDateTime date);
	}
}
