package com.gmail.marcelod;

import com.awesomecontrols.subwindow.SubWindow;
import com.awesomecontrols.subwindow.SubWindowDesktop;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.PWA;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * A sample Vaadin view class.
 * <p>
 * To implement a Vaadin view just extend any Vaadin component and
 * use @Route annotation to announce it in a URL as a Spring managed
 * bean.
 * Use the @PWA annotation make the application installable on phones,
 * tablets and some desktop browsers.
 * <p>
 * A new instance of this class is created for every new user and every
 * browser tab/window.
 */
@Route
@PWA(name = "Vaadin Application",
        shortName = "Vaadin App",
        description = "This is an example Vaadin application.",
        enableInstallPrompt = false)
@CssImport("./styles/shared-styles.css")
@CssImport(value = "./styles/vaadin-text-field-styles.css", themeFor = "vaadin-text-field")
public class MainView extends VerticalLayout {

    /**
     * Construct a new Vaadin view.
     * <p>
     * Build the initial UI state for the user accessing the application.
     *
     * @param service The message service. Automatically injected Spring managed bean.
     */
    public MainView(@Autowired GreetService service) {

        // Use TextField for standard text input
        TextField textField = new TextField("Your name");

        // Button click listeners can be defined as lambda expressions
        Button button = new Button("Say hello",
                e -> Notification.show(service.greet(textField.getValue())));

        // Theme variants give you predefined extra styles for components.
        // Example: Primary button is more prominent look.
        button.addThemeVariants(ButtonVariant.LUMO_PRIMARY);

        // You can specify keyboard shortcuts for buttons.
        // Example: Pressing enter in this view clicks the Button.
        button.addClickShortcut(Key.ENTER);

        // Use custom CSS classes to apply styling. This is defined in shared-styles.css.
        //addClassName("centered-content");

        add(textField, button);
        
        this.setSizeFull();
        
        HorizontalLayout hl = new HorizontalLayout();
        hl.setSizeFull();
        hl.setMargin(false);
        hl.setSpacing(false);
        add(hl);
        
        SubWindowDesktop swd = new SubWindowDesktop();
        swd.setSizeFull();
        hl.add(swd);
        
        SubWindow sw = new SubWindow("sw1");
        swd.add(sw);
        sw.setHeight("150px");
        sw.setWidth("300px");
        
        VerticalLayout vlsw1 = new VerticalLayout();
        TextField tf1 = new TextField("TF Label");
        vlsw1.add(tf1);
        sw.setContent(vlsw1);
        
        SubWindow sw2 = new SubWindow("SubWindow 2");
        swd.add(sw2);
        sw2.setHeight("250px");
        sw2.setWidth("300px");

        SubWindow sw3 = new SubWindow("subwindow 3");
        swd.add(sw3);
        sw3.setWidth("300px");
        sw3.setHeight("150px");
        
        VerticalLayout vlsw = new VerticalLayout();
        vlsw.setSizeFull();
        Button btn = new Button("Button");
        btn.setThemeName("contained primary");
        vlsw.add(new Label("Label"),btn);
        TextField tf2 = new TextField("TF2");
        vlsw.add(tf2);
        
        sw2.setContent(vlsw);
        
        
    }

}
