package testproject;

import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.PWA;

/**
 * The main view contains a button and a click listener.
 */
@Route("")
@PWA(name = "Project Base for Vaadin Flow", shortName = "Project Base")
public class MainView extends VerticalLayout {

	private static final long serialVersionUID = 1L;

	public MainView() {
		H3 heading_title = new H3("Welcome");

		VerticalLayout login_box = new VerticalLayout();
		TextField username = new TextField("Email");
		PasswordField password = new PasswordField("Password", "********");
		Button submit = new Button("Sign In");
		this.setHeightFull();

		add(heading_title, login_box);
		heading_title.getStyle().set("font-size", "var(--lumo-font-size-xxl)");
		heading_title.getStyle().set("margin", "70px 0px 10px 0px");

		login_box.add(username, password, submit);
		
		username.getStyle().set("padding-top", "0px");
		username.setWidth("100%");
		username.setAutofocus(true);

		password.setRevealButtonVisible(false);
		password.setWidth("100%");
		password.getStyle().set("padding-top", "0px");
		password.getStyle().set("margin-top", "8px");

		submit.addClickShortcut(Key.ENTER).allowBrowserDefault();
		submit.setWidth("100%");

		setAlignItems(Alignment.CENTER);
	}

}