package com.mycompany.sample;

import javax.servlet.annotation.WebServlet;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Grid.HeaderCell;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;

@Theme("mytheme")
public class MyUI extends UI {
  
  /** Number of columns. */
  private static final int COLUMN_COUNT = 10;
  
  /** Number of hidden columns. */
  private static final int HIDDEN_COLUMN_COUNT = 2;
  
  /** Number of frozen columns. */
  private static final int FROZEN_COLUMN_COUNT = 4;
  
  /** Number of rows. */
  private static final int ROW_COUNT = 10;
  
  
  private Grid grid;

    @Override
    protected void init(VaadinRequest vaadinRequest) {

        this.grid = new Grid();
        this.grid.setWidth("100%");
        this.grid.setSelectionMode(Grid.SelectionMode.NONE);
        this.grid.setEditorEnabled(true);
        this.grid.setColumnReorderingAllowed(true);
        
        Grid.Column column;
        
        for(int i = 0; i < COLUMN_COUNT; i++) {
          column = this.grid.addColumn(i, String.class);
          
          if(i < HIDDEN_COLUMN_COUNT) {
            column.setHidden(true);
          }
        }
        this.grid.setFrozenColumnCount(FROZEN_COLUMN_COUNT);
        
        
        // Add headers
        Grid.HeaderRow headerRow = this.grid.addHeaderRowAt(0);
        Object[] frozenPropertyIds = new Object[FROZEN_COLUMN_COUNT];
        for(int i = 0; i < FROZEN_COLUMN_COUNT; i++) {
          frozenPropertyIds[i] = i;
        }
        HeaderCell headerCell = headerRow.join(frozenPropertyIds);
        headerCell.setText("should be 'fixed'");
        
        // Add rows to grid
        Object itemId;
        Item item;
        Property property;
        Container.Indexed datasource = this.grid.getContainerDataSource();
        
        for(int i = 0; i < ROW_COUNT; i++) {
          
          itemId = datasource.addItem();
          item = datasource.getItem(itemId);
          
          for(int j = 0; j < COLUMN_COUNT; j++) {
            property = item.getItemProperty(j);
            property.setValue("value " + i + "-" + j);
          }
        }
        
        final VerticalLayout layout = new VerticalLayout();
        layout.addComponent(this.grid);
        layout.setMargin(true);
        layout.setSpacing(true);
        setContent(layout);
    }

    @WebServlet(urlPatterns = "/*", name = "MyUIServlet", asyncSupported = true)
    @VaadinServletConfiguration(ui = MyUI.class, productionMode = false)
    public static class MyUIServlet extends VaadinServlet {
    }
}
