package com.map.application.views.map;

import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapMarker;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.flowingcode.vaadin.addons.googlemaps.Markers;
import com.map.application.views.MainLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PageTitle("Googlemap")
@Route(value = "googlemap", layout = MainLayout.class)
@RouteAlias(value = "", layout = MainLayout.class)
public class GoogleMapView extends VerticalLayout implements AfterNavigationObserver {

   private static final long   serialVersionUID = -1L;

   private static final Logger LOGGER           = LogManager.getLogger(GoogleMapView.class);

   private void init() {
      this.setSizeFull();
      String apiKey = System.getenv().get("google.maps.api");
      GoogleMap gmaps = new GoogleMap(apiKey, null, null);
      gmaps.setMapType(GoogleMap.MapType.ROADMAP);
      gmaps.setCenter(new LatLon(54.217018, -1.925081));
      gmaps.setSizeFull();
      gmaps.setZoom(6);

      gmaps.addMarker(
            new GoogleMapMarker("You are here!", gmaps.getCenter(), false, Markers.GREEN));
      add(gmaps);
   }

   @Override
   public void afterNavigation(AfterNavigationEvent event) {
      init();
   }

}
