package org.epo.lifesciences.chepo.viewer.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/**
 * Collection of helpers.
 * 
 * @author <a href="mailto:dkatsubo@epo.org">Dmitry Katsubo</a>
 */
public abstract class ViewerTestUtils {

	private ViewerTestUtils() {
	}

	/**
	 * This method serializes the given object into byte stream and deserializes it back.
	 */
	public static final <T> T serializeDeserializeObject(T o) throws IOException, ClassNotFoundException {
		final ByteArrayOutputStream bos = new ByteArrayOutputStream();

		new ObjectOutputStream(bos).writeObject(o);

		return (T) new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray())).readObject();
	}
}
