package org.epo.lifesciences.chepo.viewer.container.fetchitemstrategy;

import java.io.Serializable;

import com.vaadin.data.Item;

/**
 * This interface hides the implementation of how actually item is fetched.
 * 
 * @author <a href="mailto:dkatsubo@epo.org">Dmitry Katsubo</a>
 */
public interface FetchItemStrategy<IdType> extends Serializable {

	/**
	 * Called one when a strategy is assigned to a table.<br>
	 * Note: This method call is optional; the implementation should be able to operate with some default settings.
	 */
	void init(int pageSize, double cacheRate);

	/**
	 * Returns the item by given item ID.
	 * 
	 * @throws IndexOutOfBoundsException
	 *             if item with the given ID does not exist
	 */
	Item getItem(IdType itemId);
}
