package luk;

import java.net.URI;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public class Vaadin7Scroll {

    public static void main(String[] args) throws Exception {
        new Vaadin7Scroll().startServer();
        java.awt.Desktop desktop = java.awt.Desktop.getDesktop();
        desktop.browse(new URI("http://localhost:8088/"));
    }

    private void startServer() throws Exception {
        Server server = new Server();
        server.addConnector(prepareConnector());
        server.setHandler(prepareHandlers());
        server.setStopAtShutdown(true);
        server.start();
    }

    private HandlerCollection prepareHandlers() {
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler(prepareHandler("/", "src/main/webapp"));
        return handlers;
    }

    private Connector prepareConnector() {
        Connector connector = new SelectChannelConnector();
        connector.setPort(8088);
        connector.setHost("localhost");
        return connector;
    }

    private WebAppContext prepareHandler(String contextPath, String war) {
        WebAppContext appCtx = new WebAppContext();
        appCtx.setContextPath(contextPath);
        appCtx.setWar(war);
        appCtx.setServerClasses(null);
        return appCtx;
    }
}
