package com.area22;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.*;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Input;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.shared.ui.LoadMode;

import java.util.UUID;

//@NpmPackage(value = "highlight.js", version = "9.15.10")
//@JsModule(value="highlight.js/lib/highlight.js")

/**
 * The main view contains a button and a click listener.
 */

@Route("")
@PWA(name = "Project Base for Vaadin", shortName = "Project Base")

@NpmPackage(value = "highlight.js", version = "9.15.10")
@JsModule(value="highlight.js/lib/index.js", loadMode = LoadMode.EAGER)
@CssImport(value="highlight.js/styles/darcula.css")
@JavaScript(value="./src/test.js")

public class MainView extends VerticalLayout {

    private static final String EXAMPLE_JSON = "{\n" +
            "\"example_field\": \"test\"\n"+
            "}\n";

    private static final String STYLE_DOCUMENT_JS =
            "document.querySelectorAll('pre code').forEach((block) => {\n" +
                    "    hljs.highlightBlock(block);\n" +
                    "  });";

    public MainView() {
        Button button = new Button("Click me",
                event -> Notification.show("Clicked!"));

        // JSON Content
        Div jsonContent = setupCodeDiv(EXAMPLE_JSON, "json");

        // Style the Document
        UI.getCurrent().getPage().executeJs(STYLE_DOCUMENT_JS);

        add(button);
        add(jsonContent);
    }

    /** Setup Code div */
    private Div setupCodeDiv(String codeText, String type) {
        Element pre = new Element("pre");
        Element code = new Element("code");
        code.setAttribute("class", type);
        code.setText(codeText);
        pre.appendChild(code);

        Div content = new Div();
        content.getElement().appendChild(pre);
        content.setSizeFull();

        return content;
    }
}
