/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import amd.Quantize;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.carrot2.util.BufferedImageUtils;

public class ColorQuantizer {
    public static final int MAX_INDEXED_COLORS = 255;

    public static BufferedImage quantize(BufferedImage source) {
        return ColorQuantizer.quantize(source, Color.WHITE);
    }

    public static BufferedImage quantize(BufferedImage source, Color matteColor) {
        return ColorQuantizer.quantize(source, matteColor, 255);
    }

    public static BufferedImage quantize(BufferedImage source, Color matteColor, int maxColors) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage mattedSource = BufferedImageUtils.matte(source, matteColor);
        int[][] bitmap = BufferedImageUtils.getRgb(mattedSource);
        int[] colors = Quantize.quantizeImage(bitmap, maxColors);
        int[] colorsWithAlpha = new int[colors.length + 1];
        System.arraycopy(colors, 0, colorsWithAlpha, 1, colors.length);
        colorsWithAlpha[0] = matteColor.getRGB();
        IndexColorModel colorModel = new IndexColorModel(8, colorsWithAlpha.length, colorsWithAlpha, 0, false, 0, 0);
        BufferedImage quantized = new BufferedImage(width, height, 13, colorModel);
        WritableRaster raster = quantized.getRaster();
        int[][] rgb = BufferedImageUtils.getRgb(source);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int value = (rgb[x][y] & 0xFF000000) != 0 ? bitmap[x][y] + 1 : 0;
                raster.setPixel(x, y, new int[]{value});
            }
        }
        return quantized;
    }

    public static BufferedImage reduce(BufferedImage source) {
        int width = source.getWidth();
        int height = source.getHeight();
        if (BufferedImageUtils.hasPartialTransparency(source)) {
            throw new IllegalArgumentException("The source image cannot contain translucent areas");
        }
        int[] colorsWithAlpha = BufferedImageUtils.getDistictColors(source, 1);
        if (colorsWithAlpha.length - 1 > 255) {
            throw new IllegalArgumentException("The source image cannot contain more than 255 colors");
        }
        IndexColorModel colorModel = new IndexColorModel(8, colorsWithAlpha.length, colorsWithAlpha, 0, false, 0, 0);
        BufferedImage quantized = new BufferedImage(width, height, 13, colorModel);
        int[][] rgb = BufferedImageUtils.getRgb(source);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if ((rgb[x][y] & 0xFF000000) == 0) continue;
                quantized.setRGB(x, y, source.getRGB(x, y));
            }
        }
        return quantized;
    }

    public static ColorReductionInfo getColorReductionInfo(BufferedImage source) {
        return new ColorReductionInfo(BufferedImageUtils.hasPartialTransparency(source), BufferedImageUtils.countDistictColors(source));
    }

    public static class ColorReductionInfo {
        public int distictColors;
        public boolean hasPartialTransparency;

        public ColorReductionInfo(boolean hasPartialTransparency, int distictColors) {
            this.hasPartialTransparency = hasPartialTransparency;
            this.distictColors = distictColors;
        }

        public boolean canReduceWithoutQualityLoss() {
            return !this.hasPartialTransparency && this.distictColors <= 255;
        }
    }
}

