/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites.message;

import com.google.common.collect.Lists;
import java.util.List;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageSink;

public class MessageLog {
    private int line = 0;
    private String cssPath = null;
    private final List<MessageSink> sinks;

    public MessageLog(MessageSink ... sinks) {
        this.sinks = Lists.newArrayList((Object[])sinks);
    }

    public void log(Message.MessageLevel level, Message.MessageType type, Object ... arguments) {
        for (MessageSink sink : this.sinks) {
            sink.add(new Message(level, type, this.cssPath, this.line, arguments));
        }
    }

    public void info(Message.MessageType type, Object ... arguments) {
        this.log(Message.MessageLevel.INFO, type, arguments);
    }

    public void notice(Message.MessageType type, Object ... arguments) {
        this.log(Message.MessageLevel.IE6NOTICE, type, arguments);
    }

    public void deprecation(Message.MessageType type, Object ... arguments) {
        this.log(Message.MessageLevel.DEPRECATION, type, arguments);
    }

    public void warning(Message.MessageType type, Object ... arguments) {
        this.log(Message.MessageLevel.WARN, type, arguments);
    }

    public void error(Message.MessageType type, Object ... arguments) {
        this.log(Message.MessageLevel.ERROR, type, arguments);
    }

    public void status(Message.MessageType type, Object ... arguments) {
        this.log(Message.MessageLevel.STATUS, type, arguments);
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setCssFile(String cssFilePath) {
        this.cssPath = cssFilePath;
    }

    public void addMessageSink(MessageSink sink) {
        this.sinks.add(sink);
    }
}

