/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.labs.smartsprites.SpriteImageDirective;
import org.carrot2.labs.smartsprites.SpriteLayoutProperties;
import org.carrot2.labs.smartsprites.css.CssProperty;
import org.carrot2.labs.smartsprites.css.CssSyntaxUtils;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpriteReferenceDirective {
    public static final String PROPERTY_SPRITE_REF = "sprite-ref";
    private static final Set<String> ALLOWED_PROPERTIES = ImmutableSet.of((Object)"sprite-ref");
    public final String spriteRef;
    public final SpriteLayoutProperties spriteLayoutProperties;

    public SpriteReferenceDirective(String spriteImageId, SpriteLayoutProperties spriteLayoutProperties) {
        this.spriteRef = spriteImageId;
        this.spriteLayoutProperties = spriteLayoutProperties;
    }

    public static SpriteReferenceDirective parse(String directiveString, Map<String, SpriteImageDirective> spriteImages, MessageLog messageCollector) {
        Map<String, CssProperty> rules = CssSyntaxUtils.propertiesAsMap(CssSyntaxUtils.extractRules(directiveString, messageCollector));
        LinkedHashSet properties = Sets.newLinkedHashSet(rules.keySet());
        properties.removeAll(ALLOWED_PROPERTIES);
        properties.removeAll(SpriteLayoutProperties.ALLOWED_PROPERTIES);
        if (!properties.isEmpty()) {
            messageCollector.warning(Message.MessageType.UNSUPPORTED_PROPERTIES_FOUND, CollectionUtils.toString(properties));
        }
        if (!CssSyntaxUtils.hasNonBlankValue(rules, PROPERTY_SPRITE_REF)) {
            messageCollector.warning(Message.MessageType.SPRITE_REF_NOT_FOUND, new Object[0]);
            return null;
        }
        String spriteRef = rules.get((Object)PROPERTY_SPRITE_REF).value;
        SpriteImageDirective spriteImageDirective = spriteImages.get(spriteRef);
        if (spriteImageDirective == null) {
            messageCollector.warning(Message.MessageType.REFERENCED_SPRITE_NOT_FOUND, spriteRef);
            return null;
        }
        return new SpriteReferenceDirective(spriteRef, SpriteLayoutProperties.parse(directiveString, spriteImageDirective.layout, spriteImageDirective.spriteLayoutProperties, messageCollector));
    }
}

