/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.carrot2.labs.smartsprites.SmartSpritesParameters;
import org.carrot2.labs.smartsprites.SpriteImage;
import org.carrot2.labs.smartsprites.SpriteImageDirective;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.util.BufferedImageUtils;
import org.carrot2.util.ColorQuantizer;

public class SpriteImageRenderer {
    public final SmartSpritesParameters parameters;
    private final MessageLog messageLog;

    SpriteImageRenderer(SmartSpritesParameters parameters, MessageLog messageLog) {
        this.parameters = parameters;
        this.messageLog = messageLog;
    }

    BufferedImage[] render(SpriteImage spriteImage) {
        BufferedImage sprite = spriteImage.sprite;
        SpriteImageDirective spriteImageDirective = spriteImage.spriteImageOccurrence.spriteImageDirective;
        boolean isPng = spriteImageDirective.format == SpriteImageDirective.SpriteImageFormat.PNG;
        boolean isJpg = spriteImageDirective.format == SpriteImageDirective.SpriteImageFormat.JPG;
        boolean isPngAuto = isPng && this.parameters.getSpritePngDepth() == SmartSpritesParameters.PngDepth.AUTO;
        boolean isPngDirect = isPng && this.parameters.getSpritePngDepth() == SmartSpritesParameters.PngDepth.DIRECT;
        ColorQuantizer.ColorReductionInfo colorReductionInfo = ColorQuantizer.getColorReductionInfo(sprite);
        boolean canReduceWithoutQualityLoss = colorReductionInfo.canReduceWithoutQualityLoss();
        BufferedImage[] result = new BufferedImage[2];
        if (isPngDirect || isPngAuto && !canReduceWithoutQualityLoss || isJpg) {
            result[0] = sprite;
            if (this.parameters.isSpritePngIe6() && isPng && BufferedImageUtils.hasTransparency(sprite) && spriteImageDirective.ie6Mode != SpriteImageDirective.Ie6Mode.NONE) {
                result[1] = this.quantize(sprite, spriteImage, colorReductionInfo, Message.MessageLevel.IE6NOTICE);
                spriteImage.hasReducedForIe6 = true;
            } else if (spriteImageDirective.matteColor != null) {
                this.messageLog.warning(Message.MessageType.IGNORING_MATTE_COLOR_NO_SUPPORT, spriteImageDirective.spriteId);
            }
            return result;
        }
        if (canReduceWithoutQualityLoss) {
            if (spriteImageDirective.matteColor != null) {
                this.messageLog.warning(Message.MessageType.IGNORING_MATTE_COLOR_NO_PARTIAL_TRANSPARENCY, spriteImageDirective.spriteId);
            }
            result[0] = ColorQuantizer.reduce(sprite);
            return result;
        }
        result[0] = this.quantize(sprite, spriteImage, colorReductionInfo, Message.MessageLevel.WARN);
        return result;
    }

    private BufferedImage quantize(BufferedImage sprite, SpriteImage spriteImage, ColorQuantizer.ColorReductionInfo colorReductionInfo, Message.MessageLevel logLevel) {
        Color matte;
        SpriteImageDirective spriteImageDirective = spriteImage.spriteImageOccurrence.spriteImageDirective;
        if (colorReductionInfo.hasPartialTransparency) {
            this.messageLog.log(logLevel, Message.MessageType.ALPHA_CHANNEL_LOSS_IN_INDEXED_COLOR, spriteImageDirective.spriteId);
        } else {
            this.messageLog.log(logLevel, Message.MessageType.TOO_MANY_COLORS_FOR_INDEXED_COLOR, spriteImageDirective.spriteId, colorReductionInfo.distictColors, 255);
        }
        if (spriteImageDirective.matteColor != null) {
            matte = spriteImageDirective.matteColor;
        } else {
            if (colorReductionInfo.hasPartialTransparency) {
                this.messageLog.log(logLevel, Message.MessageType.USING_WHITE_MATTE_COLOR_AS_DEFAULT, spriteImageDirective.spriteId);
            }
            matte = Color.WHITE;
        }
        BufferedImage quantized = ColorQuantizer.quantize(sprite, matte);
        return quantized;
    }
}

