/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.carrot2.labs.smartsprites.SpriteImageDirective;
import org.carrot2.labs.smartsprites.SpriteImageOccurrence;
import org.carrot2.labs.smartsprites.SpriteReferenceDirective;
import org.carrot2.labs.smartsprites.SpriteReferenceOccurrence;
import org.carrot2.labs.smartsprites.css.CssProperty;
import org.carrot2.labs.smartsprites.css.CssSyntaxUtils;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.labs.smartsprites.resource.ResourceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpriteDirectiveOccurrenceCollector {
    private static final Pattern SPRITE_IMAGE_DIRECTIVE = Pattern.compile("/\\*+\\s+(sprite:[^*]*)\\*+/");
    private static final Pattern SPRITE_REFERENCE_DIRECTIVE = Pattern.compile("/\\*+\\s+(sprite-ref:[^*]*)\\*+/");
    private final MessageLog messageLog;
    private final ResourceHandler resourceHandler;

    SpriteDirectiveOccurrenceCollector(MessageLog messageLog, ResourceHandler resourceHandler) {
        this.resourceHandler = resourceHandler;
        this.messageLog = messageLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<SpriteImageOccurrence> collectSpriteImageOccurrences(String cssFile) throws FileNotFoundException, IOException {
        ArrayList occurrences = Lists.newArrayList();
        BufferedReader reader = new BufferedReader(this.resourceHandler.getResourceAsReader(cssFile));
        this.messageLog.setCssFile(null);
        this.messageLog.info(Message.MessageType.READING_SPRITE_IMAGE_DIRECTIVES, cssFile);
        this.messageLog.setCssFile(cssFile);
        int lineNumber = -1;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                SpriteImageDirective directive;
                this.messageLog.setLine(++lineNumber);
                String spriteImageDirectiveString = SpriteDirectiveOccurrenceCollector.extractSpriteImageDirectiveString(line);
                if (spriteImageDirectiveString == null || (directive = SpriteImageDirective.parse(spriteImageDirectiveString, this.messageLog)) == null) continue;
                occurrences.add(new SpriteImageOccurrence(directive, cssFile, lineNumber));
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)reader);
        }
        return occurrences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<SpriteReferenceOccurrence> collectSpriteReferenceOccurrences(String cssFile, Map<String, SpriteImageDirective> spriteImageDirectives) throws FileNotFoundException, IOException {
        ArrayList directives = Lists.newArrayList();
        BufferedReader reader = new BufferedReader(this.resourceHandler.getResourceAsReader(cssFile));
        this.messageLog.setCssFile(null);
        this.messageLog.info(Message.MessageType.READING_SPRITE_REFERENCE_DIRECTIVES, cssFile);
        this.messageLog.setCssFile(cssFile);
        int lineNumber = -1;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                SpriteReferenceDirective directive;
                this.messageLog.setLine(++lineNumber);
                String directiveString = SpriteDirectiveOccurrenceCollector.extractSpriteReferenceDirectiveString(line);
                if (directiveString == null) continue;
                CssProperty backgroundProperty = this.extractSpriteReferenceCssProperty(line);
                String imageUrl = CssSyntaxUtils.unpackUrl(backgroundProperty.value, this.messageLog);
                if (imageUrl == null || (directive = SpriteReferenceDirective.parse(directiveString, spriteImageDirectives, this.messageLog)) == null) continue;
                directives.add(new SpriteReferenceOccurrence(directive, imageUrl, cssFile, lineNumber, backgroundProperty.important));
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)reader);
        }
        return directives;
    }

    Multimap<String, SpriteImageOccurrence> collectSpriteImageOccurrences(Collection<String> filePaths) throws FileNotFoundException, IOException {
        LinkedListMultimap spriteImageOccurrencesByFile = LinkedListMultimap.create();
        for (String cssFile : filePaths) {
            this.messageLog.setCssFile(cssFile);
            Collection<SpriteImageOccurrence> spriteImageOccurrences = this.collectSpriteImageOccurrences(cssFile);
            spriteImageOccurrencesByFile.putAll((Object)cssFile, spriteImageOccurrences);
        }
        return spriteImageOccurrencesByFile;
    }

    Multimap<String, SpriteReferenceOccurrence> collectSpriteReferenceOccurrences(Collection<String> files, Map<String, SpriteImageDirective> spriteImageDirectivesBySpriteId) throws FileNotFoundException, IOException {
        LinkedListMultimap spriteEntriesByFile = LinkedListMultimap.create();
        for (String cssFile : files) {
            this.messageLog.setCssFile(cssFile);
            Collection<SpriteReferenceOccurrence> spriteReferenceOccurrences = this.collectSpriteReferenceOccurrences(cssFile, spriteImageDirectivesBySpriteId);
            spriteEntriesByFile.putAll((Object)cssFile, spriteReferenceOccurrences);
        }
        return spriteEntriesByFile;
    }

    Map<String, SpriteImageOccurrence> mergeSpriteImageOccurrences(Multimap<String, SpriteImageOccurrence> spriteImageOccurrencesByFile) {
        LinkedHashMap spriteImageDirectivesBySpriteId = Maps.newLinkedHashMap();
        for (Map.Entry entry : spriteImageOccurrencesByFile.entries()) {
            String cssFile = (String)entry.getKey();
            SpriteImageOccurrence spriteImageOccurrence = (SpriteImageOccurrence)entry.getValue();
            this.messageLog.setCssFile(cssFile);
            if (spriteImageDirectivesBySpriteId.containsKey(spriteImageOccurrence.spriteImageDirective.spriteId)) {
                this.messageLog.warning(Message.MessageType.IGNORING_SPRITE_IMAGE_REDEFINITION, new Object[0]);
                continue;
            }
            spriteImageDirectivesBySpriteId.put(spriteImageOccurrence.spriteImageDirective.spriteId, spriteImageOccurrence);
        }
        return spriteImageDirectivesBySpriteId;
    }

    static Multimap<String, SpriteReferenceOccurrence> mergeSpriteReferenceOccurrences(Multimap<String, SpriteReferenceOccurrence> spriteEntriesByFile) {
        LinkedListMultimap spriteReferenceOccurrencesBySpriteId = LinkedListMultimap.create();
        for (SpriteReferenceOccurrence spriteReferenceOccurrence : spriteEntriesByFile.values()) {
            spriteReferenceOccurrencesBySpriteId.put((Object)spriteReferenceOccurrence.spriteReferenceDirective.spriteRef, (Object)spriteReferenceOccurrence);
        }
        return spriteReferenceOccurrencesBySpriteId;
    }

    static String extractSpriteImageDirectiveString(String cssLine) {
        Matcher matcher = SPRITE_IMAGE_DIRECTIVE.matcher(cssLine);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    static String extractSpriteReferenceDirectiveString(String css) {
        Matcher matcher = SPRITE_REFERENCE_DIRECTIVE.matcher(css);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    CssProperty extractSpriteReferenceCssProperty(String css) {
        Matcher matcher = SPRITE_REFERENCE_DIRECTIVE.matcher(css);
        String noDirective = matcher.replaceAll("").trim();
        List<CssProperty> rules = CssSyntaxUtils.extractProperties(noDirective);
        if (rules.size() == 0) {
            this.messageLog.warning(Message.MessageType.NO_BACKGROUND_IMAGE_RULE_NEXT_TO_SPRITE_REFERENCE_DIRECTIVE, css);
            return null;
        }
        if (rules.size() > 1) {
            this.messageLog.warning(Message.MessageType.MORE_THAN_ONE_RULE_NEXT_TO_SPRITE_REFERENCE_DIRECTIVE, css);
            return null;
        }
        CssProperty backgroundImageRule = (CssProperty)rules.iterator().next();
        if (!backgroundImageRule.rule.equals("background-image")) {
            this.messageLog.warning(Message.MessageType.NO_BACKGROUND_IMAGE_RULE_NEXT_TO_SPRITE_REFERENCE_DIRECTIVE, css);
            return null;
        }
        return backgroundImageRule;
    }
}

