/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.carrot2.labs.smartsprites.SmartSpritesParameters;
import org.carrot2.labs.smartsprites.SpriteBuilder;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.labs.smartsprites.message.PrintStreamMessageSink;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class SmartSprites {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        SmartSpritesParameters parameters = new SmartSpritesParameters();
        CmdLineParser parser = new CmdLineParser((Object)parameters);
        parser.setUsageWidth(80);
        if (args.length == 0) {
            SmartSprites.printUsage(parser);
            return;
        }
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            SmartSprites.printUsage(parser);
            System.out.println("\n" + e.getMessage());
            return;
        }
        MessageLog messageLog = new MessageLog(new PrintStreamMessageSink(System.out, parameters.getLogLevel()));
        new SpriteBuilder(parameters, messageLog).buildSprites();
    }

    private static void printUsage(CmdLineParser parser) {
        System.out.print("Usage: smartsprites");
        parser.printSingleLineUsage((OutputStream)System.out);
        System.out.println();
        System.out.println("\nPlease see http://csssprites.org for detailed option descriptions.");
    }
}

